
export interface Employee {
  id: string;
  name: string;
  title: string;
  description: string;
  image_url: string;
  votes: number;
}

export interface User {
  id: string;
  email: string;
  hasVoted: boolean;
  votedFor?: string;
  isAdmin: boolean;
  role?: AdminRole;
}

export type AdminRole = 'super_admin' | 'voting_admin' | 'viewer';

export interface VotingData {
  isOpen: boolean;
  closingDate: string;
  employees: Employee[];
}

export interface VoteAnalytics {
  id: string;
  vote_timestamp: string;
  user_email: string;
  browser?: string;
  device?: string;
  os?: string;
}
