
import { useLocation } from "react-router-dom";
import { useEffect } from "react";
import { Button } from "@/components/ui/button";
import { useNavigate } from "react-router-dom";

const NotFound = () => {
  const location = useLocation();
  const navigate = useNavigate();

  useEffect(() => {
    console.error(
      "404 Error: User attempted to access non-existent route:",
      location.pathname
    );
  }, [location.pathname]);

  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-100">
      <div className="text-center p-8 bg-white shadow-md rounded-lg">
        <div className="inline-block p-4 bg-primary/10 rounded-full mb-4">
          <h1 className="text-5xl font-bold text-primary">404</h1>
        </div>
        <p className="text-2xl font-semibold mb-4">Oops! Page not found</p>
        <p className="text-muted-foreground mb-6">
          We couldn't find the page you're looking for. Perhaps you wanted to vote?
        </p>
        <div className="flex flex-col sm:flex-row gap-3 justify-center">
          <Button onClick={() => navigate("/")}>
            Return to Home
          </Button>
          <Button variant="outline" onClick={() => navigate("/vote")}>
            Go to Voting Page
          </Button>
        </div>
      </div>
    </div>
  );
};

export default NotFound;
