
import React from 'react';
import { Button } from '@/components/ui/button';
import { useNavigate } from 'react-router-dom';
import CountdownTimer from '@/components/CountdownTimer';
import { Trophy, ChevronRight, Star } from 'lucide-react';
import { useVotingStore } from '../store/votingStore';

const HomePage = () => {
  const navigate = useNavigate();
  const { votingData } = useVotingStore();

  return (
    <div className="flex flex-col items-center">
      {/* Hero Section */}
      <div className="w-full max-w-4xl bg-gradient-to-r from-purple-100 to-indigo-100 rounded-lg p-8 mb-10 text-center">
        <div className="mb-4 flex justify-center">
          <div className="inline-flex items-center justify-center p-3 bg-primary rounded-full">
            <Trophy className="h-10 w-10 text-white" />
          </div>
        </div>
        <h1 className="text-4xl sm:text-5xl font-bold mb-4">Vote for Our Star of 2024!</h1>
        <p className="text-lg mb-6 max-w-2xl mx-auto text-gray-700">
          It's time to recognize the exceptional talent in our organization. 
          Cast your vote for the colleague who has made the biggest impact this year!
        </p>
        <div className="mb-8">
          <CountdownTimer />
        </div>
        <Button 
          size="lg" 
          onClick={() => navigate('/vote')}
          className="text-lg px-8"
        >
          Cast Your Vote <ChevronRight className="ml-2 h-5 w-5" />
        </Button>
      </div>

      {/* How It Works Section */}
      <div className="w-full max-w-4xl mb-10">
        <h2 className="text-2xl font-bold mb-6 text-center">How It Works</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="bg-white p-6 rounded-lg shadow-sm border text-center">
            <div className="mb-4 inline-flex items-center justify-center h-12 w-12 rounded-full bg-purple-100 text-primary">
              <span className="font-bold text-lg">1</span>
            </div>
            <h3 className="font-bold mb-2">Sign In</h3>
            <p className="text-sm text-gray-600">Authenticate with your company email to ensure the integrity of the voting process.</p>
          </div>
          <div className="bg-white p-6 rounded-lg shadow-sm border text-center">
            <div className="mb-4 inline-flex items-center justify-center h-12 w-12 rounded-full bg-purple-100 text-primary">
              <span className="font-bold text-lg">2</span>
            </div>
            <h3 className="font-bold mb-2">Choose a Star</h3>
            <p className="text-sm text-gray-600">Review the nominees and select the colleague who has demonstrated excellence this year.</p>
          </div>
          <div className="bg-white p-6 rounded-lg shadow-sm border text-center">
            <div className="mb-4 inline-flex items-center justify-center h-12 w-12 rounded-full bg-purple-100 text-primary">
              <span className="font-bold text-lg">3</span>
            </div>
            <h3 className="font-bold mb-2">Submit Your Vote</h3>
            <p className="text-sm text-gray-600">Cast your vote to help recognize and celebrate our outstanding team members.</p>
          </div>
        </div>
      </div>

      {/* Nominees Preview */}
      <div className="w-full max-w-4xl">
        <div className="flex justify-between items-center mb-6">
          <h2 className="text-2xl font-bold">Meet The Nominees</h2>
          <Button variant="outline" onClick={() => navigate('/vote')}>
            View All <ChevronRight className="ml-1 h-4 w-4" />
          </Button>
        </div>
        <div className="flex overflow-x-auto pb-4 space-x-4">
          {votingData.employees.slice(0, 3).map(employee => (
            <div 
              key={employee.id} 
              className="min-w-[250px] bg-white p-4 rounded-lg shadow-sm border flex flex-col items-center"
            >
              <div className="w-20 h-20 rounded-full overflow-hidden mb-3 bg-gray-100">
                <img 
                  src={employee.image_url} 
                  alt={employee.name} 
                  className="w-full h-full object-cover"
                  onError={(e) => {
                    (e.target as HTMLImageElement).src = `https://api.dicebear.com/7.x/initials/svg?seed=${encodeURIComponent(employee.name)}`;
                  }}
                />
              </div>
              <h3 className="font-bold text-center">{employee.name}</h3>
              <p className="text-sm text-gray-600 text-center mb-2">{employee.title}</p>
              <div className="flex items-center">
                <Star className="h-4 w-4 text-yellow-400 mr-1" />
                <span className="text-sm font-medium">{employee.votes} votes</span>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default HomePage;
