
import { useQuery } from '@tanstack/react-query';
import { supabase } from '@/integrations/supabase/client';
import type { Employee } from '@/types';

export const useEmployees = () => {
  return useQuery({
    queryKey: ['employees'],
    queryFn: async () => {
      const { data, error } = await supabase
        .from('employees')
        .select('*')
        .order('votes', { ascending: false });

      if (error) {
        throw error;
      }

      // Map Supabase schema to our app's Employee interface
      return data.map(employee => ({
        id: employee.id,
        name: employee.name,
        title: employee.title,
        description: employee.description,
        image_url: employee.image_url,
        votes: employee.votes
      })) as Employee[];
    },
  });
};
