
import React from 'react';
import { Card, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { UserPlus } from 'lucide-react';
import { User, AdminRole } from '@/types';
import ThemeToggle from '@/components/ThemeToggle';

interface AdminHeaderProps {
  currentUser: User | null;
  onOpenRoleForm: () => void;
}

const AdminHeader: React.FC<AdminHeaderProps> = ({ currentUser, onOpenRoleForm }) => {
  return (
    <>
      <div className="flex justify-between items-center mb-8">
        <h1 className="text-3xl font-bold">Admin Dashboard</h1>
        <div className="flex items-center gap-4">
          <ThemeToggle />
          {currentUser?.role === 'super_admin' && (
            <Button 
              onClick={onOpenRoleForm}
              variant="outline"
              className="gap-2"
            >
              <UserPlus className="h-4 w-4" />
              Manage Admin Roles
            </Button>
          )}
        </div>
      </div>
      
      {currentUser?.role && (
        <div className="mb-6">
          <Card>
            <CardContent className="pt-6">
              <div className="flex items-center justify-between">
                <div>
                  <p className="text-sm text-muted-foreground">Current Role:</p>
                  <p className="font-medium">
                    {currentUser.role === 'super_admin' ? 'Super Admin (Full Access)' : 
                     currentUser.role === 'voting_admin' ? 'Voting Admin (Limited Access)' : 
                     'Viewer (Read Only Access)'}
                  </p>
                </div>
                <div className="text-sm text-muted-foreground">
                  <p>Logged in as: <span className="font-medium">{currentUser.email}</span></p>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      )}
    </>
  );
};

export default AdminHeader;
