
import React from 'react';
import { useNavigate, Link } from 'react-router-dom';
import { Button } from '@/components/ui/button';
import { Trophy, LogOut, LogIn, BarChart3, Home, User, Users } from 'lucide-react';
import { useVotingStore } from '../store/votingStore';

const NavBar = () => {
  const { currentUser, logout } = useVotingStore();
  const navigate = useNavigate();

  const handleLogout = () => {
    logout();
    navigate('/');
  };

  return (
    <nav className="bg-white py-4 px-6 shadow-md">
      <div className="container mx-auto flex justify-between items-center">
        <Link to="/" className="flex items-center gap-2">
          <Trophy className="h-6 w-6 text-primary" />
          <span className="font-bold text-xl">StarVote</span>
        </Link>
        
        <div className="flex items-center gap-4">
          <Link to="/" className="hidden md:flex items-center gap-1 text-sm hover:text-primary transition-colors">
            <Home className="h-4 w-4" />
            <span>Home</span>
          </Link>
          
          <Link to="/vote" className="hidden md:flex items-center gap-1 text-sm hover:text-primary transition-colors">
            <Users className="h-4 w-4" />
            <span>Vote</span>
          </Link>
          
          <Link to="/results" className="hidden md:flex items-center gap-1 text-sm hover:text-primary transition-colors">
            <BarChart3 className="h-4 w-4" />
            <span>Results</span>
          </Link>
          
          {currentUser ? (
            <>
              <div className="hidden md:block text-sm">
                <span className="text-muted-foreground">
                  {currentUser.isAdmin ? 'Admin' : 'Logged in as:'}
                </span> {currentUser.email}
              </div>
              
              {currentUser.isAdmin && (
                <Button variant="outline" onClick={() => navigate('/admin')} size="sm" className="hidden md:flex">
                  Admin Panel
                </Button>
              )}
              
              <Button variant="ghost" size="sm" onClick={handleLogout}>
                <LogOut className="h-4 w-4 md:mr-2" />
                <span className="hidden md:inline">Logout</span>
              </Button>
            </>
          ) : (
            <>
              <Button variant="outline" size="sm" onClick={() => navigate('/auth')}>
                <LogIn className="h-4 w-4 md:mr-2" />
                <span className="hidden md:inline">Login</span>
              </Button>
            </>
          )}
        </div>
      </div>
    </nav>
  );
};

export default NavBar;
