
import React from 'react';
import NavBar from './NavBar';
import { Toaster } from '@/components/ui/toaster';

interface LayoutProps {
  children: React.ReactNode;
}

const Layout: React.FC<LayoutProps> = ({ children }) => {
  return (
    <div className="min-h-screen flex flex-col bg-gray-50">
      <NavBar />
      <main className="flex-1 container mx-auto py-8 px-4">
        {children}
      </main>
      <footer className="bg-white py-6 border-t">
        <div className="container mx-auto text-center text-sm text-muted-foreground">
          <p>© {new Date().getFullYear()} StarVote | Employee of the Year 2024</p>
        </div>
      </footer>
      <Toaster />
    </div>
  );
};

export default Layout;
