
import React, { useState, useEffect } from 'react';
import { useVotingStore } from '../store/votingStore';

const CountdownTimer = () => {
  const { votingData } = useVotingStore();
  const [timeLeft, setTimeLeft] = useState({
    days: 0,
    hours: 0,
    minutes: 0,
    seconds: 0,
  });

  useEffect(() => {
    const calculateTimeLeft = () => {
      const difference = new Date(votingData.closingDate).getTime() - new Date().getTime();
      
      if (difference > 0) {
        setTimeLeft({
          days: Math.floor(difference / (1000 * 60 * 60 * 24)),
          hours: Math.floor((difference / (1000 * 60 * 60)) % 24),
          minutes: Math.floor((difference / 1000 / 60) % 60),
          seconds: Math.floor((difference / 1000) % 60),
        });
      } else {
        setTimeLeft({ days: 0, hours: 0, minutes: 0, seconds: 0 });
      }
    };

    calculateTimeLeft();
    const timer = setInterval(calculateTimeLeft, 1000);

    return () => clearInterval(timer);
  }, [votingData.closingDate]);

  return (
    <div className="flex flex-col items-center">
      <h3 className="text-lg font-medium mb-2">Voting Closes In:</h3>
      <div className="flex space-x-2 md:space-x-4">
        <div className="flex flex-col items-center">
          <div className="bg-primary rounded-lg w-14 h-14 flex items-center justify-center text-white text-xl font-bold">
            {timeLeft.days}
          </div>
          <span className="text-xs mt-1">Days</span>
        </div>
        <div className="flex flex-col items-center">
          <div className="bg-primary rounded-lg w-14 h-14 flex items-center justify-center text-white text-xl font-bold">
            {timeLeft.hours}
          </div>
          <span className="text-xs mt-1">Hours</span>
        </div>
        <div className="flex flex-col items-center">
          <div className="bg-primary rounded-lg w-14 h-14 flex items-center justify-center text-white text-xl font-bold">
            {timeLeft.minutes}
          </div>
          <span className="text-xs mt-1">Min</span>
        </div>
        <div className="flex flex-col items-center">
          <div className="bg-primary rounded-lg w-14 h-14 flex items-center justify-center text-white text-xl font-bold">
            {timeLeft.seconds}
          </div>
          <span className="text-xs mt-1">Sec</span>
        </div>
      </div>
    </div>
  );
};

export default CountdownTimer;
