
import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { Routes, Route, Navigate } from "react-router-dom";
import Layout from "./components/Layout";
import NotFound from "./pages/NotFound";
import HomePage from "./pages/HomePage";
import VotePage from "./pages/VotePage";
import ResultsPage from "./pages/ResultsPage";
import AuthPage from "./pages/AuthPage";
import AdminPage from "./pages/AdminPage";
import { useVotingStore } from "./store/votingStore";
import { ThemeProvider } from "./components/ThemeProvider";

const queryClient = new QueryClient();

// Admin route guard component
const AdminRoute = ({ children }: { children: React.ReactNode }) => {
  const { currentUser } = useVotingStore();
  return currentUser?.isAdmin ? <>{children}</> : <Navigate to="/" />;
};

const App = () => (
  <ThemeProvider defaultTheme="light">
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Sonner />
        <Routes>
          <Route path="/" element={<Layout><HomePage /></Layout>} />
          <Route path="/vote" element={<Layout><VotePage /></Layout>} />
          <Route path="/results" element={<Layout><ResultsPage /></Layout>} />
          <Route path="/auth" element={<Layout><AuthPage /></Layout>} />
          <Route path="/admin" element={
            <AdminRoute>
              <Layout><AdminPage /></Layout>
            </AdminRoute>
          } />
          <Route path="*" element={<Layout><NotFound /></Layout>} />
        </Routes>
      </TooltipProvider>
    </QueryClientProvider>
  </ThemeProvider>
);

export default App;
